import json

def read_jsonl(filepath):
    with open(filepath, 'r', encoding='utf-8') as file:
        data = [json.loads(line.strip()) for line in file]
    return data

def write_jsonl(filepath, data):
    with open(filepath, 'w', encoding='utf-8') as file:
        for entry in data:
            file.write(json.dumps(entry) + '\n')

def replace_with_new_results(original_file, new_results_file, output_file):
    original_data = read_jsonl(original_file)
    
    new_results_data = read_jsonl(new_results_file)

    new_results_dict = {item['item_id']: item for item in new_results_data}

    for item in original_data:
        item_id = item['item_id']
        if item_id in new_results_dict:
            item['scores'] = new_results_dict[item_id]['scores']

    write_jsonl(output_file, original_data)

    print(f"Results updated and saved to {output_file}")

original_file = 'Your_PATH/output.jsonl'  
new_results_file = 'Your_PATH/output_extra.jsonl'     
output_file = 'Your_PATH/output_final.jsonl'     

replace_with_new_results(original_file, new_results_file, output_file)
